/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.quests.reward;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import dev.toma.gunsrpg.common.quests.reward.IAssemblyFunction;
import dev.toma.gunsrpg.common.quests.reward.IQuestItemProvider;
import dev.toma.gunsrpg.common.quests.reward.QuestRewardManager;
import dev.toma.gunsrpg.common.quests.reward.RewardProviderType;
import dev.toma.gunsrpg.util.helper.JsonHelper;
import java.util.Map;
import java.util.Random;
import net.minecraft.item.Item;
import net.minecraft.util.JSONUtils;

public interface IQuestRewardResolver {
    public IQuestItemProvider resolve(JsonObject var1, RewardProviderType var2, int var3, int var4, IAssemblyFunction[] var5, Map<String, QuestRewardManager.ItemGroup> var6);

    public static class ItemGroup
    implements IQuestRewardResolver {
        @Override
        public IQuestItemProvider resolve(JsonObject object, RewardProviderType type, int count, int weight, IAssemblyFunction[] functions, Map<String, QuestRewardManager.ItemGroup> itemGroups) {
            IAssemblyFunction[] loadedFunctions = functions;
            String id = JSONUtils.func_151200_h((JsonObject)object, (String)"group");
            QuestRewardManager.ItemGroup group = itemGroups.get(id);
            if (group == null) {
                throw new JsonSyntaxException("Unknown item group: " + id);
            }
            Item[] items = group.getItems();
            IAssemblyFunction[] groupFunctions = group.getFunctions();
            if (groupFunctions != null && groupFunctions.length > 0 && loadedFunctions == null) {
                loadedFunctions = groupFunctions;
            }
            int rewardWeight = group.getWeight();
            weight = weight > 1 ? weight : rewardWeight;
            int rewardCount = JSONUtils.func_151208_a((JsonObject)object, (String)"count", (int)1);
            count = rewardCount > 1 ? rewardCount : count;
            Random random = new Random();
            return new IQuestItemProvider.Impl(() -> items[random.nextInt(items.length)], count, weight, loadedFunctions);
        }
    }

    public static class ItemList
    implements IQuestRewardResolver {
        @Override
        public IQuestItemProvider resolve(JsonObject object, RewardProviderType type, int count, int weight, IAssemblyFunction[] functions, Map<String, QuestRewardManager.ItemGroup> itemGroups) {
            JsonArray array = JSONUtils.func_151214_t((JsonObject)object, (String)"list");
            Item[] items = JsonHelper.deserializeInto(array, Item[]::new, JsonHelper::resolveItem);
            Random random = new Random();
            return new IQuestItemProvider.Impl(() -> items[random.nextInt(items.length)], count, weight, functions);
        }
    }

    public static class SingleItem
    implements IQuestRewardResolver {
        @Override
        public IQuestItemProvider resolve(JsonObject object, RewardProviderType type, int count, int weight, IAssemblyFunction[] functions, Map<String, QuestRewardManager.ItemGroup> itemGroups) {
            if (!object.has("item")) {
                throw new JsonSyntaxException("Missing 'item' property");
            }
            Item item = JsonHelper.resolveItem(object.get("item"));
            return new IQuestItemProvider.Impl(() -> item, count, weight, functions);
        }
    }
}

